#include <bits/stdc++.h>
#define int long long
#define pb push_back
#define mp make_pair
#define all(x) (x).begin(),(x).end()
#define fi first
#define sc second
#define endl "\n"
#define pii pair<int,int>

using namespace std;

const int MAXN = 1e5+5;
const int mod7 = 1e9+7;
const int inf = 1e9+10;

vector<pii> polygon;
set<pii> ivica;

long long povrsinatrougla(int x1, int y1, int x2, int y2, int x3, int y3)
{
   return abs((x1*1ll*(y2-y3) + x2*1ll*(y3-y1)+ x3*1ll*(y1-y2))/2);
}

bool tackautrouglu(pii p1,pii p2, pii p3, pii q)
{
    long long A = povrsinatrougla(p1.fi, p1.sc, p2.fi, p2.sc, p3.fi,p3.sc);
    long long A1 = povrsinatrougla(p1.fi, p1.sc, p2.fi, p2.sc, q.fi,q.sc);
    long long A2 = povrsinatrougla(p1.fi, p1.sc, q.fi, q.sc, p3.fi,p3.sc);
    long long A3 = povrsinatrougla(q.fi, q.sc, p2.fi, p2.sc, p3.fi,p3.sc);
    return (A == (A1+A2+A3));
}

int orientation(pii a, pii b, pii c)
{
    double v = a.fi*1ll*(b.sc-c.sc) + b.fi*1ll*(c.sc-a.sc) + c.fi*1ll*(a.sc-b.sc);
    if(v<0)return -1;
    if(v>0)return 1;
    return 0;
}

long long kvadrat(int broj)
{
    return broj*broj*1ll;
}

bool isclockwise(pii a, pii b, pii c)
{
    int o = orientation(a,b,c);
    return o<0;
}

bool isColinear(pii a, pii b, pii c)
{
    return orientation(a,b,c) == 0;
}

long long area(vector<pii>& tacke) {
    long long res = 0;
    for (int i = 0; i <(int)tacke.size(); i++) {
        pii p = i ? tacke[i - 1] : tacke.back();
        pii q = tacke[i];
        res += (p.fi- q.fi) * (p.sc + q.sc);
    }
    return abs(res) / 2;
}

int r;

long long convexHull2(vector<pii>& tacke)
{
    vector<pii> trpolygon;
    pii p0 = {inf, inf};
    for(int i=0; i<r; i++)
    {
        if(p0.sc > tacke[i].sc)p0 = tacke[i];
        else if(p0.sc == tacke[i].sc && p0.fi >tacke[i].fi)p0 = tacke[i];
    }
    sort(tacke.begin(), tacke.end(), [&p0](const pii& a, const pii& b) {
        int o = orientation(p0, a, b);
        if (o == 0)
            return kvadrat(p0.fi - a.fi) + kvadrat(p0.sc-a.sc)<  kvadrat(p0.fi - b.fi) + kvadrat(p0.sc-b.sc);
        return o < 0;
    });

    for(int i=0; i<r; i++)
    {
        while(trpolygon.size()>1 && !isclockwise(trpolygon[trpolygon.size()-2], trpolygon.back(), tacke[i]))trpolygon.pop_back();
        trpolygon.pb(tacke[i]);
    }
    return area(trpolygon);
}

int n;
void convexHull(vector<pii>& tacke)
{
    pii p0 = {inf, inf};
    for(int i=0; i<n; i++)
    {
        if(p0.sc > tacke[i].sc)p0 = tacke[i];
        else if(p0.sc == tacke[i].sc && p0.fi >tacke[i].fi)p0 = tacke[i];
    }
    sort(tacke.begin(), tacke.end(), [&p0](const pii& a, const pii& b) {
        int o = orientation(p0, a, b);
        if (o == 0)
            return kvadrat(p0.fi - a.fi) + kvadrat(p0.sc-a.sc)<  kvadrat(p0.fi - b.fi) + kvadrat(p0.sc-b.sc);
        return o < 0;
    });

    for(int i=0; i<n; i++)
    {
        while(polygon.size()>1 && !isclockwise(polygon[polygon.size()-2], polygon.back(), tacke[i]))polygon.pop_back();
        polygon.pb(tacke[i]);
    }
    for(auto x: polygon)ivica.insert(x);
}




signed main()
{
    ios_base::sync_with_stdio(false),cin.tie(0), cout.tie(0);
    int tt=1;
    //cin >> tt;
    while(tt--)
    {
        cin >> n;
        vector<pii> tacke(n);
        for(int i=0; i<n; i++)cin >> tacke[i].fi >> tacke[i].sc;

        convexHull(tacke);
        int m = polygon.size();
        vector<pii> unutra;
        vector<vector<pii>> trouglovi(m);
        for(int i=0; i<n; i++)
        {
            if(ivica.count(tacke[i]))continue;
            unutra.pb(tacke[i]);
        }
        pii p0 = polygon[0];
        ivica.clear();
        int k = unutra.size();
        for(int i=0; i<k; i++)
        {
            int l = 1;
            int r = m-1;
            int trrez = r;
            while(l <= r)
            {
                int mid = l+r >> 1;
                int o = orientation(p0, polygon[mid], unutra[i]);
                if(o < 0)l = mid+1;
                else
                {
                    trrez = mid;
                    r = mid-1;
                }
            }
            int trrez2 = (m+trrez-1)%m;
            if(tackautrouglu(p0, polygon[m-1], polygon[1], unutra[i]))
            {
                trouglovi[0].pb(unutra[i]);
            }
            if(tackautrouglu(polygon[trrez], polygon[(trrez+1)%m], polygon[(m+trrez-1)%m], unutra[i]))
            {
                trouglovi[trrez].pb(unutra[i]);
            }
            if(tackautrouglu(polygon[trrez2], polygon[(trrez2+1)%m], polygon[(m+trrez2-1)%m], unutra[i]))
            {
                trouglovi[trrez2].pb(unutra[i]);
            }
        }
        //for(auto x: polygon)cout << x.fi << " " << x.sc << endl;
        long long rez = area(polygon);
        long long prez = area(polygon);
        for(int i=0; i<m; i++)
        {
            trouglovi[i].pb(polygon[(i+1)%m]);
            trouglovi[i].pb(polygon[(m+i-1)%m]);
            long long trp = 0;
            r = trouglovi.size();
            if(trouglovi[i].size()>2)trp = convexHull2(trouglovi[i]);
            long long trarea = povrsinatrougla(polygon[i].fi, polygon[i].sc, polygon[(i+1)%m].fi, polygon[(i+1)%m].sc,polygon[(m+i-1)%m].fi, polygon[(m+i-1)%m].sc);

            rez = min(rez, prez-trarea+ trp);
        }
        cout << rez << endl;

    }
}